/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.catalogue.client.screen.CatalogueModListScreen;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_7919;

public class Catalogue
implements ClientModInitializer {
    private static Map<String, BiFunction<class_437, ModContainer, class_437>> providers;

    public void onInitializeClient() {
        providers = this.findConfigFactoryProviders();
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_442) {
                int x = screen.field_22789 / 2;
                int y = screen.field_22790 / 4 + 48;
                CatalogueIconButton modButton = new CatalogueIconButton(x - 124, y + 48, 30, 0, button -> client.method_1507((class_437)new CatalogueModListScreen(screen)));
                modButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"catalogue.gui.mod_list")));
                Screens.getButtons((class_437)screen).add(modButton);
            } else if (screen instanceof class_433) {
                int x = screen.field_22789 / 2;
                int y = screen.field_22790 / 4 + 32;
                CatalogueIconButton modButton = new CatalogueIconButton(x - 124, y + 48, 30, 0, button -> client.method_1507((class_437)new CatalogueModListScreen(screen)));
                modButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"catalogue.gui.mod_list")));
                Screens.getButtons((class_437)screen).add(modButton);
            }
        });
    }

    public static Map<String, BiFunction<class_437, ModContainer, class_437>> getConfigProviders() {
        return providers;
    }

    private Map<String, BiFunction<class_437, ModContainer, class_437>> findConfigFactoryProviders() {
        HashMap factories = new HashMap();
        HashMap providers = new HashMap();
        FabricLoader.getInstance().getAllMods().forEach(container -> this.getConfigFactoryClass((ModContainer)container).ifPresent(className -> {
            Optional.ofNullable(Catalogue.createConfigFactoryProvider(className)).ifPresent(map -> map.forEach(providers::putIfAbsent));
            this.createConfigFactory((String)className).ifPresent(function -> factories.put(container.getMetadata().getId(), function));
        }));
        providers.putAll(factories);
        return ImmutableMap.copyOf(providers);
    }

    private Optional<String> getConfigFactoryClass(ModContainer container) {
        ModMetadata metadata = container.getMetadata();
        CustomValue value = metadata.getCustomValue("catalogue");
        if (value == null || value.getType() != CustomValue.CvType.OBJECT) {
            return Optional.empty();
        }
        CustomValue.CvObject catalogueObj = value.getAsObject();
        CustomValue configFactoryValue = catalogueObj.get("configFactory");
        if (configFactoryValue == null || configFactoryValue.getType() != CustomValue.CvType.STRING) {
            return Optional.empty();
        }
        return Optional.of(configFactoryValue.getAsString());
    }

    private static Map<String, BiFunction<class_437, ModContainer, class_437>> createConfigFactoryProvider(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigProviderMethod = configFactoryClass.getDeclaredMethod("createConfigProvider", new Class[0]);
            int mods = createConfigProviderMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                throw new RuntimeException("createConfigProvider is not accessible for class: " + className);
            }
            if (!Modifier.isStatic(mods)) {
                throw new RuntimeException("createConfigProvider is not static for class: " + className);
            }
            if (createConfigProviderMethod.getReturnType() != Map.class) {
                throw new RuntimeException("createConfigProvider must return a Map<String, BiFunction<Screen, ModContainer, Screen>>");
            }
            return (Map)createConfigProviderMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate config factory class: " + className);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Optional<BiFunction<class_437, ModContainer, class_437>> createConfigFactory(String className) {
        try {
            Class<?> configFactoryClass = Class.forName(className);
            Method createConfigScreenMethod = configFactoryClass.getDeclaredMethod("createConfigScreen", class_437.class, ModContainer.class);
            int mods = createConfigScreenMethod.getModifiers();
            if (!Modifier.isPublic(mods)) {
                throw new RuntimeException("createConfigScreen is not accessible for class: " + className);
            }
            if (!Modifier.isStatic(mods)) {
                throw new RuntimeException("createConfigScreen is not static for class: " + className);
            }
            return Optional.of((currentScreen, container) -> {
                try {
                    return (class_437)createConfigScreenMethod.invoke(null, currentScreen, container);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to locate config factory class: " + className);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Optional.empty();
        }
    }
}

