/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.transfer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRecipeTransfer;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BasicRecipeTransferHandler<C extends class_1703, R>
implements IRecipeTransferHandler<C, R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IConnectionToServer serverConnection;
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferInfo<C, R> transferInfo;

    public BasicRecipeTransferHandler(IConnectionToServer serverConnection, IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IRecipeTransferInfo<C, R> transferInfo) {
        this.serverConnection = serverConnection;
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.transferInfo = transferInfo;
    }

    @Override
    public Class<? extends C> getContainerClass() {
        return this.transferInfo.getContainerClass();
    }

    @Override
    public Optional<class_3917<C>> getMenuType() {
        return this.transferInfo.getMenuType();
    }

    @Override
    public RecipeType<R> getRecipeType() {
        return this.transferInfo.getRecipeType();
    }

    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(C container, R recipe, IRecipeSlotsView recipeSlotsView, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        List<class_1735> inventorySlots;
        if (!this.serverConnection.isJeiOnServer()) {
            class_5250 tooltipMessage = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)tooltipMessage);
        }
        if (!this.transferInfo.canHandle(container, recipe)) {
            IRecipeTransferError handlingError = this.transferInfo.getHandlingError(container, recipe);
            if (handlingError != null) {
                return handlingError;
            }
            return this.handlerHelper.createInternalError();
        }
        List<class_1735> craftingSlots = Collections.unmodifiableList(this.transferInfo.getRecipeSlots(container, recipe));
        if (!BasicRecipeTransferHandler.validateTransferInfo(this.transferInfo, container, craftingSlots, inventorySlots = Collections.unmodifiableList(this.transferInfo.getInventorySlots(container, recipe)))) {
            return this.handlerHelper.createInternalError();
        }
        List<IRecipeSlotView> inputItemSlotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        if (!BasicRecipeTransferHandler.validateRecipeView(this.transferInfo, container, craftingSlots, inputItemSlotViews)) {
            return this.handlerHelper.createInternalError();
        }
        InventoryState inventoryState = BasicRecipeTransferHandler.getInventoryState(craftingSlots, inventorySlots, player, container, this.transferInfo);
        if (inventoryState == null) {
            return this.handlerHelper.createInternalError();
        }
        int inputCount = inputItemSlotViews.size();
        if (!inventoryState.hasRoom(inputCount)) {
            class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)message);
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations(this.stackHelper, inventoryState.availableItemStacks, inputItemSlotViews, craftingSlots);
        if (transferOperations.missingItems.size() > 0) {
            class_5250 message = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForMissingSlots((class_2561)message, transferOperations.missingItems);
        }
        if (!RecipeTransferUtil.validateSlots(player, transferOperations.results, craftingSlots, inventorySlots)) {
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            boolean requireCompleteSets = this.transferInfo.requireCompleteSets(container, recipe);
            PacketRecipeTransfer packet = PacketRecipeTransfer.fromSlots(transferOperations.results, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
            this.serverConnection.sendPacketToServer(packet);
        }
        return null;
    }

    public static <C extends class_1703, R> boolean validateTransferInfo(IRecipeTransferInfo<C, R> transferInfo, C container, List<class_1735> craftingSlots, List<class_1735> inventorySlots) {
        Set<Integer> craftingSlotIndexes = BasicRecipeTransferHandler.slotIndexes(craftingSlots);
        Set<Integer> inventorySlotIndexes = BasicRecipeTransferHandler.slotIndexes(inventorySlots);
        Set<Integer> containerSlotIndexes = BasicRecipeTransferHandler.slotIndexes((Collection<class_1735>)container.field_7761);
        if (!containerSlotIndexes.containsAll(craftingSlotIndexes)) {
            LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references crafting slot indexes [{}] that are not found in the inventory container slots [{}]", transferInfo.getClass(), container.getClass(), (Object)StringUtil.intsToString(craftingSlotIndexes), (Object)StringUtil.intsToString(containerSlotIndexes));
            return false;
        }
        if (!containerSlotIndexes.containsAll(inventorySlotIndexes)) {
            LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Recipes Transfer Helper references inventory slot indexes [{}] that are not found in the inventory container slots [{}]", transferInfo.getClass(), container.getClass(), (Object)StringUtil.intsToString(inventorySlotIndexes), (Object)StringUtil.intsToString(containerSlotIndexes));
            return false;
        }
        return true;
    }

    public static <C extends class_1703, R> boolean validateRecipeView(IRecipeTransferInfo<C, R> transferInfo, C container, List<class_1735> craftingSlots, List<IRecipeSlotView> inputSlots) {
        if (inputSlots.size() > craftingSlots.size()) {
            LOGGER.error("Recipe View {} does not work for container {}. The Recipe View has more input slots ({}) than the number of inventory crafting slots ({})", transferInfo.getClass(), container.getClass(), (Object)inputSlots.size(), (Object)craftingSlots.size());
            return false;
        }
        return true;
    }

    public static Set<Integer> slotIndexes(Collection<class_1735> slots) {
        return slots.stream().map(s -> s.field_7874).collect(Collectors.toSet());
    }

    @Nullable
    public static <C extends class_1703, R> InventoryState getInventoryState(Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots, class_1657 player, C container, IRecipeTransferInfo<C, R> transferInfo) {
        class_1799 stack;
        HashMap<class_1735, class_1799> availableItemStacks = new HashMap<class_1735, class_1799>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (class_1735 slot : craftingSlots) {
            stack = slot.method_7677();
            if (stack.method_7960()) continue;
            if (!slot.method_7674(player)) {
                LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Crafting Slot number {}", transferInfo.getClass(), container.getClass(), (Object)slot.field_7874);
                return null;
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot, stack.method_7972());
        }
        for (class_1735 slot : inventorySlots) {
            stack = slot.method_7677();
            if (!stack.method_7960()) {
                if (!slot.method_7674(player)) {
                    LOGGER.error("Recipe Transfer helper {} does not work for container {}. The Player is not able to move items out of Inventory Slot number {}", transferInfo.getClass(), container.getClass(), (Object)slot.field_7874);
                    return null;
                }
                availableItemStacks.put(slot, stack.method_7972());
                continue;
            }
            ++emptySlotCount;
        }
        return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
    }

    public record InventoryState(Map<class_1735, class_1799> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        public boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }
}

