/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.library.util.RecipeErrorUtil;
import net.minecraft.class_1860;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CraftingExtensionHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Handler<? extends class_3955>> handlers = new ArrayList<Handler<? extends class_3955>>();
    private final Set<Class<? extends class_3955>> handledClasses = new HashSet<Class<? extends class_3955>>();
    private final Map<class_8786<? extends class_3955>, @Nullable ICraftingCategoryExtension<? extends class_3955>> cache = new IdentityHashMap<class_8786<? extends class_3955>, ICraftingCategoryExtension<? extends class_3955>>();

    public <T extends class_3955> void addRecipeExtension(Class<? extends T> recipeClass, ICraftingCategoryExtension<T> recipeExtension) {
        if (!class_3955.class.isAssignableFrom(recipeClass)) {
            throw new IllegalArgumentException("Recipe handlers must handle a specific class that inherits from CraftingRecipe. Instead got: " + recipeClass);
        }
        if (this.handledClasses.contains(recipeClass)) {
            throw new IllegalArgumentException("A Recipe Extension has already been registered for this class:" + recipeClass);
        }
        this.handledClasses.add(recipeClass);
        this.handlers.add(new Handler<T>(recipeClass, recipeExtension));
    }

    public <R extends class_3955> ICraftingCategoryExtension<R> getRecipeExtension(class_8786<R> recipeHolder) {
        return this.getOptionalRecipeExtension(recipeHolder).orElseThrow(() -> {
            String recipeName = RecipeErrorUtil.getNameForRecipe(recipeHolder);
            return new RuntimeException("Failed to create recipe extension for recipe: " + recipeName);
        });
    }

    public <R extends class_3955> Optional<ICraftingCategoryExtension<R>> getOptionalRecipeExtension(class_8786<R> recipeHolder) {
        if (this.cache.containsKey(recipeHolder)) {
            ICraftingCategoryExtension<? extends class_3955> extension = this.cache.get(recipeHolder);
            if (extension != null) {
                ICraftingCategoryExtension<? extends class_3955> cast = extension;
                return Optional.of(cast);
            }
            return Optional.empty();
        }
        Optional<ICraftingCategoryExtension<R>> result = this.getBestRecipeHandler(recipeHolder).map(Handler::getExtension);
        this.cache.put(recipeHolder, result.orElse(null));
        return result;
    }

    private <T extends class_3955> Stream<Handler<T>> getRecipeHandlerStream(class_8786<T> recipeHolder) {
        return this.handlers.stream().flatMap(handler -> handler.optionalCast(recipeHolder).stream());
    }

    private <T extends class_3955> Optional<Handler<T>> getBestRecipeHandler(class_8786<T> recipeHolder) {
        Class<?> recipeClass = ((class_3955)recipeHolder.comp_1933()).getClass();
        ArrayList<Object> assignableHandlers = new ArrayList<Object>();
        List<Handler<T>> allHandlers = this.getRecipeHandlerStream(recipeHolder).toList();
        for (Handler<T> handler : allHandlers) {
            Class<T> clazz = handler.getRecipeClass();
            if (clazz.equals(recipeClass)) {
                return Optional.of(handler);
            }
            assignableHandlers.removeIf(h -> h.getRecipeClass().isAssignableFrom(handlerRecipeClass));
            if (!assignableHandlers.stream().noneMatch(h -> handlerRecipeClass.isAssignableFrom(h.getRecipeClass()))) continue;
            assignableHandlers.add(handler);
        }
        if (assignableHandlers.isEmpty()) {
            return Optional.empty();
        }
        if (assignableHandlers.size() == 1) {
            return Optional.of((Handler)assignableHandlers.get(0));
        }
        Class<?> superClass = recipeClass;
        while (!Object.class.equals(superClass)) {
            superClass = superClass.getSuperclass();
            for (Handler handler : assignableHandlers) {
                if (!handler.getRecipeClass().equals(superClass)) continue;
                return Optional.of(handler);
            }
        }
        List<Class> assignableClasses = assignableHandlers.stream().map(Handler::getRecipeClass).toList();
        LOGGER.warn("Found multiple matching recipe handlers for {}: {}", recipeClass, assignableClasses);
        return Optional.of((Handler)assignableHandlers.get(0));
    }

    private static class Handler<T extends class_3955> {
        private final Class<? extends T> recipeClass;
        private final ICraftingCategoryExtension<T> extension;

        public Handler(Class<? extends T> recipeClass, ICraftingCategoryExtension<T> extension) {
            this.recipeClass = recipeClass;
            this.extension = extension;
        }

        public <V extends class_3955> Optional<Handler<V>> optionalCast(class_8786<V> recipeHolder) {
            if (this.isHandled(recipeHolder)) {
                Handler cast = this;
                return Optional.of(cast);
            }
            return Optional.empty();
        }

        public boolean isHandled(class_8786<?> recipeHolder) {
            class_1860 recipe = recipeHolder.comp_1933();
            if (this.recipeClass.isInstance(recipe)) {
                class_8786<?> cast = recipeHolder;
                return this.extension.isHandled(cast);
            }
            return false;
        }

        public Class<? extends T> getRecipeClass() {
            return this.recipeClass;
        }

        public ICraftingCategoryExtension<T> getExtension() {
            return this.extension;
        }
    }
}

