/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.external;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import carpet.fakes.MinecraftServerInterface;
import carpet.logging.HUDController;
import carpet.network.ServerNetworkHandler;
import carpet.patches.EntityPlayerMPFake;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetExpression;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Module;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.LoadException;
import carpet.script.value.MapValue;
import carpet.script.value.StringValue;
import carpet.utils.CarpetProfiler;
import carpet.utils.Messenger;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Carpet {
    public static Map<String, class_2561> getScarpetHeaders() {
        return HUDController.scarpet_headers;
    }

    public static Map<String, class_2561> getScarpetFooters() {
        return HUDController.scarpet_footers;
    }

    public static void updateScarpetHUDs(MinecraftServer server, List<class_3222> players) {
        HUDController.update_hud(server, players);
    }

    public static class_2561 Messenger_compose(Object ... messages) {
        return Messenger.c(messages);
    }

    public static void Messenger_message(class_2168 source, Object ... messages) {
        Messenger.m(source, messages);
    }

    public static ThreadLocal<Boolean> getImpendingFillSkipUpdates() {
        return CarpetSettings.impendingFillSkipUpdates;
    }

    public static Runnable startProfilerSection(String name) {
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section(null, name, CarpetProfiler.TYPE.GENERAL);
        return () -> CarpetProfiler.end_current_section(token);
    }

    public static void MinecraftServer_addScriptServer(MinecraftServer server, CarpetScriptServer scriptServer) {
        ((MinecraftServerInterface)server).addScriptServer(scriptServer);
    }

    public static boolean isValidCarpetPlayer(class_3222 player) {
        return ServerNetworkHandler.isValidCarpetPlayer(player);
    }

    public static String getPlayerStatus(class_3222 player) {
        return ServerNetworkHandler.getPlayerStatus(player);
    }

    public static MapValue getAllCarpetRules() {
        Collection<CarpetRule<?>> rules = CarpetServer.settingsManager.getCarpetRules();
        MapValue carpetRules = new MapValue(Collections.emptyList());
        rules.forEach(rule -> carpetRules.put(new StringValue(rule.name()), new StringValue(RuleHelper.toRuleString(rule.value()))));
        CarpetServer.extensions.forEach(e -> {
            SettingsManager manager = e.extensionSettingsManager();
            if (manager == null) {
                return;
            }
            manager.getCarpetRules().forEach(rule -> carpetRules.put(new StringValue(manager.identifier() + ":" + rule.name()), new StringValue(RuleHelper.toRuleString(rule.value()))));
        });
        return carpetRules;
    }

    public static String getCarpetVersion() {
        return CarpetSettings.carpetVersion;
    }

    @Nullable
    public static String isModdedPlayer(class_1657 p) {
        if (p instanceof EntityPlayerMPFake) {
            EntityPlayerMPFake fake = (EntityPlayerMPFake)p;
            return fake.isAShadow ? "shadow" : "fake";
        }
        return null;
    }

    public static void handleExtensionsAPI(CarpetExpression expression) {
        CarpetServer.extensions.forEach(e -> e.scarpetApi(expression));
    }

    public static boolean getFillUpdates() {
        return CarpetSettings.fillUpdates;
    }

    @Nullable
    public static Module fetchGlobalModule(String name, boolean allowLibraries) throws IOException {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Path globalFolder = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
            if (!Files.exists(globalFolder, new LinkOption[0])) {
                Files.createDirectories(globalFolder, new FileAttribute[0]);
            }
            try (Stream<Path> folderWalker = Files.walk(globalFolder, new FileVisitOption[0]);){
                Optional<Path> scriptPath = folderWalker.filter(script -> script.getFileName().toString().equalsIgnoreCase(name + ".sc") || allowLibraries && script.getFileName().toString().equalsIgnoreCase(name + ".scl")).findFirst();
                if (scriptPath.isPresent()) {
                    Module module = Module.fromPath(scriptPath.get());
                    return module;
                }
            }
        }
        return null;
    }

    public static void addGlobalModules(List<String> moduleNames, boolean includeBuiltIns) throws IOException {
        if (includeBuiltIns && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Path globalScripts = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
            if (!Files.exists(globalScripts, new LinkOption[0])) {
                Files.createDirectories(globalScripts, new FileAttribute[0]);
            }
            try (Stream<Path> folderWalker = Files.walk(globalScripts, FileVisitOption.FOLLOW_LINKS);){
                folderWalker.filter(f -> f.toString().endsWith(".sc")).forEach(f -> moduleNames.add(f.getFileName().toString().replaceFirst("\\.sc$", "").toLowerCase(Locale.ROOT)));
            }
        }
    }

    public static void assertRequirementMet(CarpetScriptHost host, String requiredModId, String stringPredicate) {
        Version presentVersion;
        VersionPredicate predicate;
        try {
            predicate = VersionPredicate.parse((String)stringPredicate);
        }
        catch (VersionParsingException e) {
            throw new InternalExpressionException("Failed to parse version conditions for '" + requiredModId + "' in 'requires': " + e.getMessage());
        }
        ModContainer mod = FabricLoader.getInstance().getModContainer(requiredModId).orElse(null);
        if (mod != null && (predicate.test((Object)(presentVersion = mod.getMetadata().getVersion())) || FabricLoader.getInstance().isDevelopmentEnvironment() && !(presentVersion instanceof SemanticVersion))) {
            return;
        }
        throw new LoadException(String.format("%s requires a version of mod '%s' matching '%s', which is missing!", host.getVisualName(), requiredModId, stringPredicate));
    }

    public static void initCarpetEvents() {
        CarpetEventServer.Event carpetRuleChanges = new CarpetEventServer.Event("carpet_rule_changes", 2, true){

            @Override
            public void handleAny(Object ... args) {
                CarpetRule rule = (CarpetRule)args[0];
                class_2168 source = (class_2168)args[1];
                String id = rule.settingsManager().identifier();
                Object namespace = !id.equals("carpet") ? id + ":" : "";
                this.handler.call(() -> 1.lambda$handleAny$0((String)namespace, rule), () -> source);
            }

            private static /* synthetic */ List lambda$handleAny$0(String namespace, CarpetRule rule) {
                return Arrays.asList(new StringValue(namespace + rule.name()), new StringValue(RuleHelper.toRuleString(rule.value())));
            }
        };
        SettingsManager.registerGlobalRuleObserver((source, changedRule, userInput) -> carpetRuleChanges.handleAny(changedRule, source));
    }
}

