/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.Context;
import carpet.script.annotation.ListConverter;
import carpet.script.annotation.Locator;
import carpet.script.annotation.MapConverter;
import carpet.script.annotation.OptionalConverter;
import carpet.script.annotation.Param;
import carpet.script.annotation.SimpleTypeConverter;
import carpet.script.annotation.ValueCaster;
import carpet.script.value.Value;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ClassUtils;

public interface ValueConverter<R> {
    @Nullable
    public String getTypeName();

    @Nullable
    public R convert(Value var1, @Nullable Context var2);

    @Nullable
    @Deprecated(forRemoval=true)
    default public R convert(Value value) {
        try {
            return this.convert(value, null);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    default public boolean consumesVariableArgs() {
        return false;
    }

    default public int valueConsumption() {
        return 1;
    }

    public static <R> ValueConverter<R> fromAnnotatedType(AnnotatedType annoType) {
        Class type;
        Class clazz = type = annoType.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)annoType.getType()).getRawType() : (Class)annoType.getType();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if ((type = ClassUtils.primitiveToWrapper((Class)type)) == List.class) {
            return ListConverter.fromAnnotatedType(annoType);
        }
        if (type == Map.class) {
            return MapConverter.fromAnnotatedType(annoType);
        }
        if (type == Optional.class) {
            return OptionalConverter.fromAnnotatedType(annoType);
        }
        if (annoType.getDeclaredAnnotations().length != 0) {
            if (annoType.isAnnotationPresent(Param.Custom.class)) {
                return Param.Params.getCustomConverter(annoType, type);
            }
            if (annoType.isAnnotationPresent(Param.Strict.class)) {
                return Param.Params.getStrictConverter(annoType);
            }
            if (annoType.getAnnotations()[0].annotationType().getEnclosingClass() == Locator.class) {
                return Locator.Locators.fromAnnotatedType(annoType, type);
            }
        }
        if (Value.class.isAssignableFrom(type)) {
            return Objects.requireNonNull(ValueCaster.get(type), "Value subclass " + type + " is not registered. Register it in ValueCaster to use it");
        }
        if (type == Context.class) {
            return Param.Params.CONTEXT_PROVIDER;
        }
        if (type == Context.Type.class) {
            return Param.Params.CONTEXT_TYPE_PROVIDER;
        }
        return Objects.requireNonNull(SimpleTypeConverter.get(type), "Type " + type + " is not registered. Register it in SimpleTypeConverter to use it");
    }

    @Nullable
    default public R checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type contextType) {
        return !valueIterator.hasNext() ? null : (R)this.convert(valueIterator.next(), context);
    }
}

