/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteHelper;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelType;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockData;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureLayoutHelper;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.util.TextureAtlases;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_806;
import net.minecraft.class_809;

public class ConnectingBakedModel
extends WrappedBakedModel {
    private final class_4590 modelRotation;
    private final Map<class_2960, ConnectionPredicate> predicates;
    private final IntObjectMap<Mesh> quadCache = new IntObjectHashMap();
    private final ThreadLocal<MeshBuilder> meshBuilder = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().meshBuilder());

    public ConnectingBakedModel(class_1087 original, class_4590 modelRotation, Map<class_2960, ConnectionPredicate> predicates) {
        super(original);
        this.modelRotation = modelRotation;
        this.predicates = predicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Mesh quads;
        SurroundingBlockData data = blockView == null || pos == null ? null : this.getModelData(blockView, pos, state);
        int hashCode = data == null ? 0 : data.hashCode();
        IntObjectMap<Mesh> intObjectMap = this.quadCache;
        synchronized (intObjectMap) {
            quads = (Mesh)this.quadCache.get(hashCode);
        }
        if (quads == null) {
            MeshBuilder meshBuilder = this.meshBuilder.get();
            QuadEmitter meshEmitter = meshBuilder.getEmitter();
            context.pushTransform(quad -> {
                meshEmitter.copyFrom((QuadView)quad);
                meshEmitter.emit();
                return true;
            });
            SpriteFinder spriteFinder = SpriteFinder.get((class_1059)class_310.method_1551().method_1554().method_24153(TextureAtlases.getBlocks()));
            context.pushTransform(quad -> this.remapQuad(quad, spriteFinder.find((QuadView)quad), data));
            this.original.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            context.popTransform();
            context.popTransform();
            quads = meshBuilder.build();
            IntObjectMap<Mesh> intObjectMap2 = this.quadCache;
            synchronized (intObjectMap2) {
                this.quadCache.putIfAbsent((Object)hashCode, (Object)quads);
            }
        } else {
            quads.outputTo(context.getEmitter());
        }
    }

    @Override
    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.original.emitItemQuads(stack, randomSupplier, context);
    }

    protected boolean remapQuad(MutableQuadView quad, class_1058 sprite, SurroundingBlockData surroundingBlocks) {
        class_2960 spriteIdentifier;
        if (SpriteHelper.getTextureType(sprite) != DefaultTextureTypes.CONNECTING) {
            return true;
        }
        ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).getLayout();
        ConnectingTextureData.RenderType renderType = ((ConnectingTextureSprite)sprite).getRenderType();
        if (renderType != null) {
            quad.material(FusionClient.getRenderTypeMaterial(renderType));
        }
        class_2960 class_29602 = spriteIdentifier = sprite.method_45851() == null || sprite.method_45851().method_45816() == null ? ConnectingModelType.DEFAULT_CONNECTION_KEY : sprite.method_45851().method_45816();
        if (!this.predicates.containsKey(spriteIdentifier)) {
            spriteIdentifier = ConnectingModelType.DEFAULT_CONNECTION_KEY;
        }
        SurroundingBlockData.SideConnections connections = surroundingBlocks.getConnections(spriteIdentifier, quad.nominalFace());
        int[] uv = ConnectingTextureLayoutHelper.getStatePosition(layout, connections);
        ConnectingBakedModel.adjustVertexDataUV(quad, uv[0], uv[1], sprite);
        return true;
    }

    private static void adjustVertexDataUV(MutableQuadView quad, int newU, int newV, class_1058 sprite) {
        for (int i = 0; i < 4; ++i) {
            float width = sprite.method_4577() - sprite.method_4594();
            float u = quad.u(i) + width * (float)newU;
            float height = sprite.method_4575() - sprite.method_4593();
            float v = quad.v(i) + height * (float)newV;
            quad.uv(i, u, v);
        }
    }

    public SurroundingBlockData getModelData(class_1920 level, class_2338 pos, class_2680 state) {
        return SurroundingBlockData.create(level, pos, this.modelRotation, this.predicates);
    }

    @Override
    public boolean isVanillaAdapter() {
        return false;
    }

    @Override
    public boolean method_4713() {
        return super.method_4713();
    }

    @Override
    public class_809 method_4709() {
        return super.method_4709();
    }

    @Override
    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

