/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.SpriteContentsExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7766;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7766.class}, priority=900)
public class SpriteLoaderMixin {
    @Inject(method={"loadAndStitch"}, at={@At(value="RETURN")})
    private void initializeTextures(class_3300 resourceManager, class_2960 atlas, int i, Executor executor, CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.comp_1044();
            for (Map.Entry entry : textures.entrySet()) {
                class_1058 newTexture;
                class_2960 identifier = (class_2960)entry.getKey();
                class_1058 texture = (class_1058)entry.getValue();
                Pair<TextureType<Object>, Object> textureData = ((SpriteContentsExtension)texture.method_45851()).fusionTextureMetadata();
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((class_7766.class_7767)preparations, atlas, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + identifier + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + identifier + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
                ((SpriteContentsExtension)texture.method_45851()).clearFusionTextureMetadata();
            }
            return preparations;
        });
    }
}

